function bit_output=QAM_demodulation(symbols,n,Eb)

A=sqrt(Eb);
B=A*sqrt(0.4);
C=  A*sqrt(1/7);

% QAM demodulation
% Set the belonging area of each bits (see the QAM_mapping)

if n == 4                        % example: (b1,b2) 
    for ii=1:length(symbols)            % 01 | 00
        if real(symbols(ii)) > 0        % -- - --
            bit_output(2*ii) = 0;       % 11 | 10
        else                     % real(a)>0  =   b2=0
            bit_output(2*ii) = 1;       % imag(a)>0  =   b1=0
        end
        if imag(symbols(ii)) > 0 
            bit_output(2*ii-1) = 0;
        else
            bit_output(2*ii-1) = 1;
        end
    end
end

% 0100 0101 | 0001 0000
% 0110 0111 | 0011 0010
% ----------|----------
% 1110 1111 | 1011 1010
% 1100 1101 | 1001 1000


if n == 16
    for ii=1:length(symbols)
        if imag(symbols(ii)) > 0
            bit_output(4*ii-3) = 0;
        else
            bit_output(4*ii-3) = 1;
        end
        if real(symbols(ii)) > 0
            bit_output(4*ii-2) = 0;
        else
            bit_output(4*ii-2) = 1;
        end
        if abs(imag(symbols(ii)))>2*B
            bit_output(4*ii-1) = 0;
        else
            bit_output(4*ii-1) = 1;
        end
        if abs(real(symbols(ii)))>2*B
            bit_output(4*ii) = 0;
        else
            bit_output(4*ii) = 1;
        end
    end
end


% 010000 010001 010101 010100 | 000100 000101 000001 000000
% 010010 010011 010111 010110 | 000110 000111 000011 000010
% 011010 011011 011111 011110 | 001110 001111 001011 001010
% 011000 011001 011101 011100 | 001100 001101 001001 001000
%-----------------------------|----------------------------
% 111000 111001 111101 111100 | 101100 101101 101001 101000
% 111010 111011 111111 111110 | 101110 101111 101011 101010
% 110010 110011 110111 110110 | 100110 100111 100011 100010
% 110000 110001 110101 110100 | 100100 100101 100001 100000
       

if n == 64
    for ii = 1:length(symbols)
        % upper half: 0 in first position
        if imag(symbols(ii)) > 0
            bit_output(6*ii-5) = 0;
        else
            bit_output(6*ii-5) = 1;
        end
        % right half: 0 in second position
        if real(symbols(ii)) > 0
            bit_output(6*ii-4) = 0;
        else
            bit_output(6*ii-4) = 1;
        end
        % two rows on top/on the bottom: 0 in third position
        if abs(imag(symbols(ii)))>4*C
            bit_output(6*ii-3) = 0;
        else
            bit_output(6*ii-3) = 1;
        end
        % two rows extreme right-hand side/extreme left-hand side: 0 in 4th
        % position
        if abs(real(symbols(ii)))>4*C
            bit_output(6*ii-2) = 0;
        else
            bit_output(6*ii-2) = 1;
        end
        % if the  imaginary part is higher than 6C: 0 in 5th position
        if abs(abs(imag(symbols(ii)))-4*C)>2*C
            bit_output(6*ii-1) = 0;
        else
            bit_output(6*ii-1) = 1;
        end
        % if the real part is higher than 6C: 0 in 6th position
        if abs(abs(real(symbols(ii)))-4*C)>2*C
            bit_output(6*ii) = 0;
        else
            bit_output(6*ii) = 1;
        end
    end
end

end
                  